﻿var donotcallclearexpired = {
    context: $(".v-donotcallclearexpired"),
    defaultMonthToDelete: 36,
    initialize: function () {
        a4.parent().donotcalls.hideBusyBox();

        donotcallclearexpired.bindEvents();

        a4.initializeInputs(donotcallclearexpired.context);

        donotcallclearexpired.setDateUntilDelete(donotcallclearexpired.defaultMonthToDelete);
    },
    bindEvents: function () {
        $("#clearExpired", donotcallclearexpired.context).on("click", function () {
            donotcallclearexpired.clearExpired($("#Months").val() || 0);
        });
        
        $("#Months", donotcallclearexpired.context).on("change", function () {
            donotcallclearexpired.setDateUntilDelete($(this).val());
            $("#ConfirmedMonth", donotcallclearexpired.context).prop('checked', false);
            $("#clearExpired", donotcallclearexpired.context).prop("disabled", true);
        });

        $("#ConfirmedMonth", donotcallclearexpired.context).on("change", function () {
            $("#clearExpired", donotcallclearexpired.context).prop("disabled", !$(this).is(":checked"));
        });

    },
    clearExpired: function (months) {
        a4.callServerMethod(a4.getAction("DoNotCallsClearExpired", "MultiMode", "Settings"), { months: months },
            function (success) {
                a4.parent().donotcalls.refreshContent();
                modalDialog.close();
            }, null, { blockElement: donotcalls.context }
        );

    },
    setDateUntilDelete: function (month) {
        var date = new Date();
        date.setMonth(date.getMonth() - month);
        var date = a4.formatDate(date);
        var deleteDoNotCallList = resources.deleteDoNotCallList;
        deleteDoNotCallList = deleteDoNotCallList.replace(/{(.*?)}/g, date);
        
        $(".confirmCheck label").html(deleteDoNotCallList);
    }
}

$(document).ready(function () {
    if (donotcallclearexpired.context.length > 0) {
        donotcallclearexpired.initialize();
    }
});